struct VertexToPixel
{
    float4 Position     : POSITION;
    float2 TexCoords    : TEXCOORD0;
};

struct PixelToFrame
{
    float4 Color : COLOR0;
};


 float4x4 xWorldViewProjection;


Texture xColoredTexture;

sampler ColoredTextureSampler = sampler_state { texture = <xColoredTexture> ; magfilter = LINEAR; minfilter = LINEAR; mipfilter=LINEAR; AddressU = mirror; AddressV = mirror;};
VertexToPixel SimplestVertexShader( float4 inPos : POSITION, float2 inTexCoords : TEXCOORD0)
{
    VertexToPixel Output = (VertexToPixel)0;
    

     Output.Position = mul(inPos, xWorldViewProjection);

    Output.TexCoords = inTexCoords;
    
    return Output;    
}

PixelToFrame OurFirstPixelShader(VertexToPixel PSIn)
{
    PixelToFrame Output = (PixelToFrame)0;

    Output.Color = tex2D(ColoredTextureSampler, PSIn.TexCoords);

    return Output;
}

technique Simplest
{
    pass Pass0
    {
        VertexShader = compile vs_1_1 SimplestVertexShader();
        PixelShader = compile ps_1_1 OurFirstPixelShader();
    }
}
